<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rolepengeluarans', function (Blueprint $table) {
            $table->id();
            $table->foreignId('supplier_id')->constrained(
                table: 'suppliers',
                indexName: 'rolepengeluaran_supplier_id'
            )->onDelete('cascade');
            $table->string('kd_pengeluaran')->unique();
            $table->double('total');
            $table->enum('sts_role', ['Y', 'N']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rolepengeluarans');
    }
};
